-- legacy PhysX: not localized.
plugin geometry nvCapsule
name:"PhysX Capsule"
category:"NVIDIA PhysX"
classID:#(0x77b350e0, 0x3a5c318a)
extends:capsule
replaceui:true
invisible:true
(
	parameters basic rollout: nvCapsule_param_ui
	(
		radius       	type:#float    default: 1.0 ui:ui_radius      
		height      	type:#float    default: 2.0 ui:ui_height      
		heighttype 	    type:#integer  default: 0

		-- add a try catch block for bug #4628: Pausing clothing simulation actually resets (oftentimes)
		-- it is not a good solution, but this bug happens with an old Max file. It should not be problem in future.
		on radius set val do
		(
			try( delegate.radius = val ) catch()
		)
		
		on height set val do
		(
			try( delegate.height = val ) catch()
		)
		
		on heighttype set val do
		(
			try( delegate.heighttype = val ) catch()
		)

	)
	
	rollout nvCapsule_param_ui "Parameters" rolledUp:false
	(
		spinner			ui_radius     "Radius:"    align:#right width:100 range:[0.01, PxMaxValue, 0.1] scale:0.01 type:#worldunits tooltip:"Radius of capsule in cm."
		spinner			ui_height     "Height:"    align:#right width:100 range:[0.01, PxMaxValue, 0.1] scale:0.01 type:#worldunits tooltip:"Height of capsule in cm."
	)
)

plugin geometry nvBox
name:"PhysX Box"
category:"NVIDIA PhysX"
classID:#(0x47894d2c, 0x73a82635)
extends:box
replaceui:true
invisible:true
(
	parameters basic rollout: nvBox_param_ui
	(
		width       type:#float default: 0.1 ui:ui_width
		length      type:#float default: 0.1 ui:ui_length
		height      type:#float default: 0.1 ui:ui_height
		widthsegs   type:#integer default: 1
		lengthsegs  type:#integer default: 1
		heightsegs  type:#integer default: 1
		
		on width set val do
		(
			delegate.width = val
		)
		
		on length set val do
		(
			delegate.length = val
		)
		
		on height set val do
		(
			delegate.height = val
		)
		
		on widthsegs set val do
		(
			delegate.widthsegs = val
		)

		on lengthsegs set val do
		(
			delegate.lengthsegs = val
		)
		
		on heightsegs set val do
		(
			delegate.heightsegs = val
		)		
	)
	
	rollout nvBox_param_ui "Parameters" rolledUp:false
	(
		spinner			ui_length     "Length:"    align:#right width:100 range:[0.01, PxMaxValue, 0.1] scale:0.01 type:#worldunits tooltip:"Length of box in cm."
		spinner			ui_width      "Width:"     align:#right width:100 range:[0.01, PxMaxValue, 0.1] scale:0.01 type:#worldunits tooltip:"Width of box in cm."
		spinner			ui_height     "Height:"    align:#right width:100 range:[0.01, PxMaxValue, 0.1] scale:0.01 type:#worldunits tooltip:"Height of box in cm."
	)
)

plugin geometry nvSphere
name:"PhysX Sphere"
category:"NVIDIA PhysX"
classID:#(0x507646ae, 0xec130c5)
extends:sphere
replaceui:true
invisible:true
(
	parameters basic  rollout: nvSphere_param_ui
	(
		radius       type:#float default: 1.0  ui: ui_radius
		segs         type:#integer default: 32

		on radius set val do
		(
			delegate.radius = val
		)
		
		on segs set val do
		(
			delegate.segs = val
		)
	)
	
	rollout nvSphere_param_ui "Parameters" rolledUp:false
	(
		spinner			ui_radius     "Radius:"    align:#right width:100 range:[0.01, PxMaxValue, 0.1] scale:0.01 type:#worldunits tooltip:"Radius of sphere in cm."
		--spinner		ui_segs 	  "Segments:"		           align:#right width:100 range:[4, 100, 1] type:#integer
	)
)

fn PxCreateAsDynamic =
(
	currentNode = PxGetCurrentNode()
	if currentNode != undefined then
	(
		if PxSeletionCanCreateRB() then 
		(
			PxDynamicRBNodes(PxGetSelectedNodes())
			PxDynamicRBNodes(PxGetSelectedDummyHelpers())
			if (PxGetSelectionCount()+ PxGetSelectedDummyHelpersCount()) == 1 then (max modify mode)
			px_selectionChanged()  -- Update PhysX Tools dialog
		)
		else
		(
			Messagebox nvpxText.TXT_MODIFIERRB_NOT_GEOM
		)
	)	
)

fn PxCreateAsKinetic =
(
	currentNode = PxGetCurrentNode()
	if pxCurrentNode != undefined then
	(
		if PxSeletionCanCreateRB() then 
		(
			PxKinematicRBNodes(PxGetSelectedNodes())
			PxKinematicRBNodes(PxGetSelectedDummyHelpers())
			if (PxGetSelectionCount() + PxGetSelectedDummyHelpersCount()) == 1 then (max modify mode)
			px_selectionChanged()  -- Update PhysX Tools dialog
		)
		else
		(
			Messagebox nvpxText.TXT_MODIFIERRB_NOT_GEOM
		)
	)
)

fn PxCreateAsStatic =
(
	currentNode = PxGetCurrentNode()
	if currentNode != undefined then
	(
		if PxSeletionCanCreateRB() then 
		(
			PxStaticRBNodes(PxGetSelectedNodes())
			PxStaticRBNodes(PxGetSelectedDummyHelpers())
			if (PxGetSelectionCount() + PxGetSelectedDummyHelpersCount()) == 1 then (max modify mode)
			px_selectionChanged()  -- Update PhysX Tools dialog
		)
		else
		(
			Messagebox nvpxText.TXT_MODIFIERRB_NOT_GEOM
		)
	)
)


global PxModsToDelete                  -- needs to delete the modifiers in the array after adding the new physics modifier.

fn PxIsPhysXMod modRB =
(
	temp = classOf modRB
	(temp == PhysXModRB)
)

fn PxRecordExistingPhysXMod node modRB =
(
	mods = node.modifiers
	PxModsToDelete = #()
	for i in mods do
	(
		if PxIsPhysXMod(i) then append PxModsToDelete i
	)
)

fn PxRemoveFormerPhysXMod node modRB =
(
	for i in PxModsToDelete do
	(
		if i != modRB then
		(
			deleteModifier node i
		)
		/* I tried to keep the old same named modifier and remove the new modifier. But this may cause problem in multiple selection mode 
		if i.name == modRB.name  then 
		(
			modPanel.setCurrentObject  i
			deleteModifier node modRB
		)
		else
		(
			deleteModifier node i
		)
		*/
	)
)


fn PxRBGetVolume node =
(
	if not nvpx.IsSimulating() then nvpx.RemoveAll()
	volume = nvpx.CalcVolume node
)


fn PxModRBPreAdded =
(
	t = callbacks.notificationParam()
	aNode = t[1]
	modRB  = t[2]
	--format " calling PxModRBPreAdded % %\n" aNode modRB
	if (aNode != undefined) then
	(
		if PxIsPhysXMod(modRB) then 
		(
			--PxStopSimulation()
			PxRecordExistingPhysXMod aNode modRB
			--if (PxIsHull aNode) then append PxModsToDelete modRB
		)
	)
)


fn PxModRBPostAdded =
(
	t = callbacks.notificationParam()
	local aNode = t[1]
	if aNode != undefined then
	(
		local modRB  = t[2]
		--format "aNode = %, modRB = %\n" aNode modRB
		if PxIsPhysXMod(modRB) then
		(
			local nodeCls = classof(aNode)
			if (nodeCls == UConstraint) or (nodeCls == RagdollHelper) then
			(
				-- not add RB modifier to Constraint
				deleteModifier aNode modRB
			)
			else
			(
				PxRemoveFormerPhysXMod aNode modRB
				-- if simulation is running, add it to scene.
				if nvpx.IsSimulating() then 
				(
					-- skip group head or group member node
					if not (isgroupmember(aNode) or isgrouphead(aNode)) then
					(
						px_add_rigidbody aNode
					) 
				)
				-- need clear "LastPose" which is used to make the original pose of one object before simulation
				if (GetUserProp aNode "LastPose") != undefined then SetUserProp aNode "LastPose" undefined
			)
		)
	)
)

fn PxModRBPreDelete =
(
	t = callbacks.notificationParam()
	aNode = t[1]
	aMod  = t[2]
	if classof(aMod) == ModRBClass do
	(
		nvpx.RemoveRigidbody aNode
		-- need clear "LastPose" which is used to make the original pose of one object before simulation
		if (aNode != undefined) and (GetUserProp aNode "LastPose") != undefined then SetUserProp aNode "LastPose" undefined
	)
)

fn PxModRBCloneHappend =
(
	t = callbacks.notificationParam()
	nodes = t[1]
	cloned = t[2]
	action = t[3]

	if action != 2 then (
		for  i in cloned do (
			modRB = PxGetModRB i
			if modRB != undefined then (
				--PxSetRBNodeColor aNode modRB.type
				if modRB.meshType < PX_MESHTYPE_ORIGINAL then (
					--modRB.physicalMesh = undefined
				)
				
				-- clear global pose
				nvpx.SetInitialPose i i.transform
			)
			
			-- clear old type saved global pose
			t = getuserprop i "LastPose"
			if t != undefined then setuserprop i "LastPose" undefined
		)
	)
)

fn PxModRBMirrorHappened =
(
	t = callbacks.notificationParam()
	nodes = t[1]
	--format "PxModRBMirrorHappened(), %\n" nodes
)

callbacks.removeScripts id:#PhysXModRB
callbacks.addScript #preModifierAdded    "PxModRBPreAdded()"       id:#PhysXModRB
callbacks.addScript #postModifierAdded   "PxModRBPostAdded()"      id:#PhysXModRB
callbacks.addScript #preModifierDeleted  "PxModRBPreDelete()"      id:#PhysXModRB
callbacks.addScript #postNodesCloned     "PxModRBCloneHappend()"   id:#PhysXModRB
